
markup.push({

    // This provides enough info to map AH3's presets, and the keys it uses,
    // to AH4's presets.
    
    // AH3 had lists of KeyValuePaths provided in markup - defining what gets saved
    // by a preset. It turned out that we saved every setting for a block in all cases. The
	// hand edited list had no value and was error prone - we often forgot to update the list
	// when adding new node features.
    
    // In AH4, we save a preset by having the node save (raSaveToPlist) the same
    // way all saving and undo/redo is handled. (If ever needed, we could provide alternate
	// methods, which for most nodes could just call through to these existing methods).
    
    // When importing, we create an AH4 node, then load AH3's presets to it as AH3 did
	// before having the AH4 node save the preset. Mostly, we can map AH3's presets to
	// AH4 with no extra information. For some special cases, the node provides
	// an importAH3Preset: and that gets used instead.
	
    
    // MARK: app source

    ApplicationSourcePresets: // name tied to saved presets and AH3 import
    {
        h4PresetsId: "ApplicationPresets",
        geNodeClass: "GEAppWrapperNode",
    },

    
    // MARK: input device

    AudioDeviceInputPresets:
    {
        h4PresetsId: "InputDevicePresets",
        geNodeClass: "AHKAudioDeviceInputNode",
    },

    
    // MARK: output device

    AudioDeviceOutputPresets:
    {
        h4PresetsId: "OutputDevicePresets",
        geNodeClass: "AHKAudioDeviceOutputNode",
    },

    
    // MARK: Declick

    RADeclickPresets:
    {
        h4PresetsId: "DeclickPresets",
        geNodeClass: "AHRADeclickNode",
    },

    // MARK: Dehum

    RADehumPresets:
    {
        h4PresetsId: "DehumPresets",
        geNodeClass: "AHRADehumNode",
    },

    // MARK: Denoise

    RADenoisePresetsV2:
    {
        h4PresetsId: "DenoisePresets",
        geNodeClass: "GEDenoiseNode",
    },
    
    
    // MARK: Equalizer
    
    Equalizer10Presets:
    {
        h4PresetsId: "EqualizerPresets",
        geNodeClass: "AHEqualizer10Node",
    },

    
    // MARK: Ducking

    DuckingPresets:
    {
        h4PresetsId: "DuckingPresets4",
        geNodeClass: "GEDuckingNode",
    },

    
    // MARK: Recorder

    RecorderPresets:
    {
        h4PresetsId: "RecorderPresets4",
        geNodeClass: "GEAudioRecorderNode",
    },

    
    // MARK: Audio Units

	// note that audio unit import is special cased in import code
	AudioUnitPresets:
	{
	    geNodeClass: "AHAudioUnitNode",
	},

    
    // MARK: Broadcast

    BroadcastPresets:
    {
        h4PresetsId: "BroadcastPresets4",
        geNodeClass: "GEShoutcastNode",
    },

        
    // MARK: Live Stream RTMP

    RTMPPresets:
    {
        h4PresetsId: "LiveStreamPresets",
        geNodeClass: "GERTMPNode",
    },

})
